// Generated by CoffeeScript 1.10.0
(function() {
  var HandlerStack, root;

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  HandlerStack = (function() {
    function HandlerStack() {
      this.debug = false;
      this.eventNumber = 0;
      this.stack = [];
      this.counter = 0;
      this.stopBubblingAndTrue = new Object();
      this.stopBubblingAndFalse = new Object();
      this.restartBubbling = new Object();
    }

    HandlerStack.prototype.push = function(handler) {
      handler._name || (handler._name = "anon-" + this.counter);
      this.stack.push(handler);
      return handler.id = ++this.counter;
    };

    HandlerStack.prototype.unshift = function(handler) {
      handler._name || (handler._name = "anon-" + this.counter);
      handler._name += "/unshift";
      this.stack.unshift(handler);
      return handler.id = ++this.counter;
    };

    HandlerStack.prototype.bubbleEvent = function(type, event) {
      var eventNumber, handler, j, len, ref, result;
      this.eventNumber += 1;
      eventNumber = this.eventNumber;
      ref = this.stack.slice(0).reverse();
      for (j = 0, len = ref.length; j < len; j++) {
        handler = ref[j];
        if ((handler != null ? handler.id : void 0) && handler[type]) {
          this.currentId = handler.id;
          result = handler[type].call(this, event);
          if (this.debug) {
            this.logResult(eventNumber, type, event, handler, result);
          }
          if (!result) {
            if (this.isChromeEvent(event)) {
              DomUtils.suppressEvent(event);
            }
            return false;
          }
          if (result === this.stopBubblingAndTrue) {
            return true;
          }
          if (result === this.stopBubblingAndFalse) {
            return false;
          }
          if (result === this.restartBubbling) {
            return this.bubbleEvent(type, event);
          }
        } else {
          if (this.debug) {
            this.logResult(eventNumber, type, event, handler, "skip");
          }
        }
      }
      return true;
    };

    HandlerStack.prototype.remove = function(id) {
      var handler, i, j, ref, results;
      if (id == null) {
        id = this.currentId;
      }
      results = [];
      for (i = j = ref = this.stack.length - 1; j >= 0; i = j += -1) {
        handler = this.stack[i];
        if (handler.id === id) {
          handler.id = null;
          this.stack.splice(i, 1);
          break;
        } else {
          results.push(void 0);
        }
      }
      return results;
    };

    HandlerStack.prototype.isChromeEvent = function(event) {
      return ((event != null ? event.preventDefault : void 0) != null) || ((event != null ? event.stopImmediatePropagation : void 0) != null);
    };

    HandlerStack.prototype.alwaysContinueBubbling = function(handler) {
      handler();
      return true;
    };

    HandlerStack.prototype.neverContinueBubbling = function(handler) {
      handler();
      return false;
    };

    HandlerStack.prototype.logResult = function(eventNumber, type, event, handler, result) {
      var label;
      if (type === "registerKeyQueue") {
        return;
      }
      label = (function() {
        switch (result) {
          case this.stopBubblingAndTrue:
            return "stop/true";
          case this.stopBubblingAndFalse:
            return "stop/false";
          case this.restartBubbling:
            return "rebubble";
          case "skip":
            return "skip";
          case true:
            return "continue";
        }
      }).call(this);
      label || (label = result ? "continue/truthy" : "suppress");
      return console.log("" + eventNumber, type, handler._name, label);
    };

    HandlerStack.prototype.show = function() {
      var handler, j, len, ref, results;
      console.log(this.eventNumber + ":");
      ref = this.stack.slice(0).reverse();
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        handler = ref[j];
        results.push(console.log("  ", handler._name));
      }
      return results;
    };

    HandlerStack.prototype.reset = function() {
      return this.stack = [];
    };

    return HandlerStack;

  })();

  root.HandlerStack = HandlerStack;

  root.handlerStack = new HandlerStack();

}).call(this);
